const puppeteer = require('puppeteer');
const path = require('path');

(async () => {
    const browser = await puppeteer.launch({
        headless: 'new',
        protocolTimeout: 180000,
        args: ['--no-sandbox', '--disable-setuid-sandbox']
    });

    const page = await browser.newPage();
    page.setDefaultNavigationTimeout(120000);
    page.setDefaultTimeout(120000);

    await page.setViewport({
        width: 1200,
        height: 800
    });

    // Original HTML file
    const htmlPath = path.join(__dirname, 'TrustCamera PitchDeck.html');
    console.log('Loading:', htmlPath);

    await page.goto(`file:///${htmlPath.replace(/\\/g, '/')}`, {
        waitUntil: 'domcontentloaded',
        timeout: 120000
    });

    console.log('Page loaded, waiting for content...');
    await new Promise(resolve => setTimeout(resolve, 3000));

    // Make all animations visible immediately
    await page.evaluate(() => {
        document.querySelectorAll('.animate-on-scroll').forEach(el => {
            el.classList.add('visible');
            el.style.opacity = '1';
            el.style.transform = 'translateY(0)';
        });
    });

    await new Promise(resolve => setTimeout(resolve, 1000));

    // Get full page height
    const bodyHeight = await page.evaluate(() => document.body.scrollHeight);
    console.log('Page height:', bodyHeight, 'px');

    console.log('Generating single-page PDF...');

    await page.pdf({
        path: path.join(__dirname, 'TrustCamera-PitchDeck.pdf'),
        width: '1200px',
        height: `${bodyHeight}px`,
        printBackground: true,
        margin: { top: '0', right: '0', bottom: '0', left: '0' }
    });

    console.log('PDF created: TrustCamera-PitchDeck.pdf (1 page, full content)');

    await browser.close();
})();
